function newgames=makenew(rowinput,K)

N=86;
Row=[];
for i=1:N
    Row=[Row; rowinput{i}];
end

Row=reshape(Row,1,[])';

uniqueval=unique(Row);
uniqueval(find(uniqueval==0))=[]; %drop 0
n=length(uniqueval);

r=length(find(Row~=0));
for i=1:n
    prop(i)=length(find(Row==uniqueval(i)))/r;
end

thresh=zeros(1,n+1);
thresh(1)=0;
for i=2:n+1
    thresh(i)=thresh(i-1)+prop(i-1);
end

row=cell(1,K);
for k=1:K
    x=unifrnd(0,1,[3,3]);
    for i=1:3
        for j=1:3
            for h=2:n+1
                if x(i,j)>thresh(h-1) && x(i,j)<thresh(h)
                    row{k}(i,j)=uniqueval(h-1);
                end
            end
        end
    end
end

column=cell(1,K);
for k=1:K
    column{k}=row{k}';
end

newgames=cell(1,2);
newgames{1}=row;
newgames{2}=column;